//
//  OPStatusHeart.m
//  The Obfuscated Path
//
//  Created by ss2cire on 12/21/08.
//  Copyright 2008 GryphonClaw Software. All rights reserved.
//

#import "OPStatusHeart.h"
#import "OPTextureManager.h"

@implementation OPStatusHeart
- (id)init
{
	self = [super init];

	if(self != nil) {
		textureID = [[OPTextureManager sharedManager] textureWithName:@"heart_full"];
		healthCount = 2;
	}
	return self;
}

- (void)draw
{
	glPushMatrix(); {
		glTranslated(location.x, location.y, 0.0);

		glEnable(GL_TEXTURE_2D);
		glBindTexture(GL_TEXTURE_2D, textureID);
	
		glBlendFunc(GL_ONE, GL_ONE_MINUS_SRC_ALPHA);
		glEnable(GL_BLEND);
		glBegin(GL_QUADS); {
			glTexCoord2f(0.0, 1.0);
			glVertex2i(0, 0);

			glTexCoord2f(0.0, 0.0);
			glVertex2i(0, 32);

			glTexCoord2f(1.0, 0.0);
			glVertex2i(32, 32);

			glTexCoord2f(1.0, 1.0);
			glVertex2i(32, 0);	
		}
		glEnd();
		glDisable(GL_TEXTURE_2D);
	}
	glPopMatrix();
}

- (void)setEmptyHeart
{
	textureID = [[OPTextureManager sharedManager] textureWithName:@"heart_empty"];
}

- (void)setHalfHeart
{
	textureID = [[OPTextureManager sharedManager] textureWithName:@"heart_half"];
}

- (void)setFullHeart
{
	textureID = [[OPTextureManager sharedManager] textureWithName:@"heart_full"];
}

- (int)healthCount
{
	return healthCount;
}

- (void)incrementHealthCount
{
	healthCount++;
	if(healthCount > 2) {
		healthCount = 2;
	}
	[self update];
}

- (void)decrementHealthCount
{
	healthCount--;
	if(healthCount < 0) {
		healthCount = 0;
	}
	[self update];
}

- (void)update
{
	switch(healthCount) {
		case 0:
			[self setEmptyHeart];
			break;
		case 1:
			[self setHalfHeart];
			break;
		case 2:
			[self setFullHeart];
			break;
	}
}
@end
